<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}
// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CGoogleMaps extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"gmap"				=> "gmap.htm",
			"header"			=> "header.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($slider , $widget = false) {
		global $_LANG_ID , $base;
		$this->__init();


		if (!is_array($slider)) {
			$slider = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:googlemaps']},
					{$this->tables['plugin:sliders']}

				WHERE 
					slider_module LIKE '{$this->name}' AND 
					gmap_id = slider_sid AND 
					slider_status = 1 AND 
					gmap_id='{$slider}'"
			);
		}

		if (!is_array($slider)) {
			return "";
		}
		

		$slider["widget"] = $widget;

		//set the default height
		if (!$slider["gmap_height"]) {
			$slider["gmap_height"] = "400";
		}

		$slider["lang_id"] = $_LANG_ID;

		$this->initScript();
		
		return $this->GoogleMap($slider);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Add($slider) {

		if (!$slider) {
			return "";
		}
		

		$this->slider = $slider;

		//move the breadcrumb		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GoogleMap($slider) {
		global $base, $_CONF;


		$template = &$this->private->templates["gmap"];

		$slider["slider_gmap_type"] = strtoupper($slider["gmap_type"]);
		$slider["height"] = $slider["gmap_height"] ? "height:{$slider[gmap_height]}" . ($slider["gmap_height_type"] == "2" ? "vh" : "px") : "";

		//get all the markers
		$markers = $this->db->QFetchRowArray(
			"SELECT * FROM 
			{$this->tables['plugin:googlemaps_markers']} as i,
			{$this->tables['plugin:googlemaps_markers_lang']} as l

			WHERE 
				i.item_id = l.item_id AND 
				item_slider = {$slider[gmap_id]} AND 
				l.lang_id = {$slider[lang_id]}
			"
		);

		if (is_array($markers)) {
			foreach ($markers as $key => $val) {

				$content = "";

				switch ($val["item_type"]) {
					//classic
					case "0":

						$content = $this->_t("gmap")->blockReplace(
							"Content",
							array(
								"_title"	=> $val["item_title"] ? $this->_t("gmap")->blockReplace("ContentTitle" , $val) : "",
								"_image"	=> $val["item_image"] ? $this->_t("gmap")->blockReplace("ContentImage" , $val) : "",
								"_body"		=> $val["item_body"] ? $this->_t("gmap")->blockReplace("ContentBody" , $val) : "",
							)
						);
							
					break;

					//raw html
					case "1":
						$content = $this->_t("gmap")->blockREplace(
							"RawHtml",
							$val
						);
					break;
				}

				$markers[$key]["content"] =  trim(
					str_replace(
						array("\n" , "\r"),
						array("" , ""),
						$content
					)
				);

				$markers[$key]["_close"]		= $val["_close"]		= $val["item_close_button"] ? "true" : "false";
				$markers[$key]["_outside"]		= $val["_outside"]		= $val["item_close_outside"] ? "true" : "false";
				$markers[$key]["_maxwidth"]		= $val["_maxwidth"]		= $val["item_max_width"] ? $this->_t("gmap")->blockReplace("MaxWidth" , $val) : "";
				$markers[$key]["_maxheight"]	= $val["_maxheight"]	= $val["item_max_height"] ? $this->_t("gmap")->blockReplace("MaxHeight" , $val) : "";


				switch ($val["item_show_marker"]) {
					//default marker
					default:
						$markers[$key]["marker_var"] = $this->_t("gmap")->BlockReplace(
							"MarkerVar",
							$val, 
							array(
								"marker"	=> $_CONF["url"] . "upload/googlemaps/marker.png",
							)
						);

						$markers[$key]["marker_window"] = $this->_t("gmap")->blockReplace("MarkerInfo" , $val );
						//hide box window

						$markers[$key]["item_css"] .= " gmap-window-no-arrow";
					break;

					//custom marker
					case "1":

						if ($val["item_marker"]) {
							$markers[$key]["marker_var"] = $this->_t("gmap")->BlockReplace(
								"MarkerVar",
								$val, 
								array(
									"marker"	=> $_CONF["url"] . "upload/googlemaps/marker_{$val[item_id]}.png",
								)
							);

							$markers[$key]["marker_window"] = $this->_t("gmap")->blockReplace("MarkerInfo" , $val );

							$markers[$key]["item_css"] .= " gmap-window-no-arrow";
						} else {						
							$markers[$key]["marker_var"] = $markers[$key]["marker_window"] = "";
						}
					break;

					//box arrow
					case "2":
						$markers[$key]["marker_var"] = $markers[$key]["marker_window"] = "";
					break;

					//nothing
					case "3":
						$markers[$key]["marker_var"] = $markers[$key]["marker_window"] = "";
						$markers[$key]["item_css"] .= " gmap-window-no-pointer";
					break;
				}
								
				$markers[$key]["auto"]	= $val["item_show"] ? $template->blockREplace("Auto" , $val) : "";
			}		
			
		}
		
		$slider["markers"] = $base->html->Table(
			$template , 
			"Markers",
			$markers
		);

		$slider["style"] = "";

		$controls = explode("," , $slider["gmap_elements"]);

		$slider["set_zoom"]			= in_array("1" , $controls) ? "true" : "false";
		$slider["set_maptype"]		= in_array("2" , $controls) ? "true" : "false";
		$slider["set_scale"]		= in_array("3" , $controls) ? "true" : "false";
		$slider["set_streetview"]	= in_array("4" , $controls) ? "true" : "false";
		$slider["set_rotate"]		= in_array("5" , $controls) ? "true" : "false";
		$slider["set_fullscreen"]	= in_array("6" , $controls) ? "true" : "false";
		$slider["set_draggable"]	= in_array("7" , $controls) ? "true" : "false";
		$slider["set_pan"]			= in_array("8" , $controls) ? "true" : "false";

		if ($slider["gmap_style"]) {
			$style = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:googlemaps_styles']} WHERE style_id=%d" , array($slider["gmap_style"]));

			if (is_array($style)) {

				if ($this->isJson($style["style_json"])) {
					$slider["style"] = $template->blockReplace(
						"Style",
						array(
							"style"	=> $style["style_json"]
						)
					);
				}
			}
			
		}
		
		//$slider["grayscale"] = $slider["gmap_grayscale"] ? $template->blockReplace("Grayscale" , $slider)  : "";

		return $template->blockReplace(
			"Main",
			$slider
		);

	}

	function isJson($string) {
		$decoded = json_decode($string);
		if ( !is_object($decoded) && !is_array($decoded) ) {
			return false;
		}
		return (json_last_error() == JSON_ERROR_NONE);
	}
	
	function ShortCode($matches) {
		return $this->Render($matches[1]);
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function InitScript() {
		global $_TSM;

		$this->__init();


		if ($this->scriptLoaded) {
			return "";
		}

		$this->scriptLoaded = true;

		$this->plugins["seo"]->AppendToHead(
			$this->private->templates["header"]->blockReplace(
				"Header" , 
				$_TSM , 
				array("app_id"	=> $this->vars->data["set_google_app_id"])
			)
		);		
	}

}

?>